<?php

 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTMobile_WS_DownloadUrl extends CTMobile_WS_Controller {

	function process(CTMobile_API_Request $request) {
		global $adb,$current_user; // Required for vtws_update API
		$record = $request->get('record');
		$current_user = $this->getActiveUser();
		$fileDetails = getFileDetails($record);
		$fileContent = false;

		if (!empty ($fileDetails)) {
			$filePath = $fileDetails['path'];
			$fileType = $fileDetails['type'];
			$fileName = $fileDetails['name'];
			$storedFileName = $fileDetails['storedname'];

			$fileName = html_entity_decode($fileName, ENT_QUOTES, vglobal('default_charset'));
			if (!empty($fileName)) {
				if(!empty($storedFileName)){
	                $savedFile = $fileDetails['attachmentsid']."_".$storedFileName;
	            }else if(is_null($storedFileName)){
	                $savedFile = $fileDetails['attachmentsid']."_".$fileName;
	            }
				while(ob_get_level()) {
					ob_end_clean();
				}
				$fileSize = filesize($filePath.$savedFile);
				//$fileSize = $fileSize + ($fileSize % 1024);

				if (fopen($filePath.$savedFile, "r")) {
					$fileContent = fread(fopen($filePath.$savedFile, "r"), $fileSize);

					/*header("Content-type: ".$fileDetails['type']);
					header("Content-Length: $fileSize");
					header("Pragma: public");
					header("Cache-Control: private");
					header("Content-Disposition: attachment; filename=\"$fileName\"");
					header("Content-Description: PHP Generated Data");
		            header("Content-Encoding: none");
		            header('Transfer-Encoding: binary');*/

		            header('Content-Description: File Transfer');
				    header('Content-Type: '.$fileType);
				    header('Content-Disposition: attachment; filename="' . basename($fileName) . '"');
				    header('Content-Transfer-Encoding: binary');
				    header('Expires: 0');
				    header('Cache-Control: must-revalidate');
				    header('Pragma: public');
				    header('Content-Length: ' . $fileSize);

				    // Clear any output buffers to avoid conflicts
				    ob_clean();
				    flush();
				}
			}
		}
		echo $fileContent;
		exit;
	}
}

function getFileDetails($record) {
	global $adb;
	$fileDetails = array();

	$result = $adb->pquery("SELECT * FROM vtiger_attachments
						WHERE attachmentsid = ?", array($record));

	if($adb->num_rows($result)) {
		$fileDetails = $adb->query_result_rowdata($result);
	}
	return $fileDetails;
}

