
$( document ).ready(function() {

    $('#modulename').on('select2:select',function (e) {
        getFields();
    });

    $('#language').on('select2:select',function (e) {
        getFields();
    });

    $(document).on('change','.tx_input',function () {
        let modulename = $('#modulename').val();
        let language = $('#language').val();
        let fieldlabel = $(this).prop('name');
        let fieldtrans = $(this).val();
        let $this = $(this);
        set_load_icon($this);
        if(fieldtrans.length > 0)
        {
            $.ajax({
                url: 'module/language/controller/get-info.php?action=set_translation',
                type: 'POST',
                data: {
                    modulename : modulename,
                    fieldlabel : fieldlabel,
                    fieldtrans : fieldtrans,
                    language: language
                },
                dataType: 'json',
                success:function(response){
                    
                    set_success_icon($this);
                },
                complete:function(response){
                    
                }
            });
        } 
    });
    
});
function getFields()
{
    var modulename = $('#modulename').val();
    var language = $('#language').val();
    if(modulename && language)
    {
        $.ajax({
            url: 'module/language/controller/get-info.php?action=get_fields&module='+modulename+'&language='+language,
            type: 'GET',
            dataType: 'json',
            success:function(response){
                if(response && Object. keys(response). length > 0)
                {
                    armar_tabla(response);
                }
            },
            complete:function(response){
                
            }
        });
    }
}
function armar_tabla(data)
{

    let tabla =  `
    <table class="">
        <thead>
            <tr>
                <th>Campo</th>
                <th>Traducción</th>
                <th></th>
            </tr>

        </thead>
        <tbody>`;
    
        for (i in data)
        {
            let translated_f = data[i].label_tranlated;
            let raw_f = data[i].label_raw;
            tabla += `
                <tr>
                    <td>${raw_f}</td>
                    <td><input type="text" class='form-control tx_input' value="${translated_f}" name="${raw_f}"></td>
                    <td class='icon'></td>
                </tr>
            `;
        }
    tabla += `
        <tbody>
    </table>`;

    $('#table_contents').html(tabla);
}

function set_load_icon(Jhtml)
{
    let icon = '<i class="fas fa-spinner fa-spin" style="--fa-primary-color: #f35305; --fa-secondary-color: #7c7c7c;"></i>';
    Jhtml.closest('tr').find('td.icon').html(icon);
}

function set_success_icon(Jhtml)
{
    let icon = '<i class="fa fa-check-circle" style="color:green;"></i>';
    Jhtml.closest('tr').find('td.icon').html(icon);
    setTimeout(() => {
        Jhtml.closest('tr').find('td.icon').html('');
    }, 2000);
}

