/**
 * Realiza una solicitud POST a una URL con los datos proporcionados y maneja la respuesta.
 * @param {string} url - La URL a la que se enviará la solicitud POST.
 * @param {FormData} formData - Los datos del formulario a enviar en la solicitud.
 * @param {string} responseType - El tipo de respuesta esperada ("json" o "text").
 * @returns {Promise} - Una promesa que se resuelve con la respuesta obtenida de la solicitud.
 * @throws {Error} - Si el tipo de respuesta no es válido o si ocurre un error en la solicitud.
 */
function enviarDatos(url, formData, responseType) {
    return fetch(url, {
      method: "POST",
      body: formData
    })
    .then(response => {
      if (responseType === "json") {
        return response.json();
      } else if (responseType === "text") {
        return response.text();
      } else {
        throw new Error("Tipo de respuesta no válido");
      }
    })
    .catch(error => {
      console.error("Error:", error);
      throw error;
    });
  }
  

window.addEventListener('DOMContentLoaded', event => {



});


