{*<!--
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
-->*}

{literal}
<style type="text/css">
.nav-tabs > li.active > a, .nav-tabs > li.active > a:hover, .nav-tabs > li.active > a:focus {
    color: #333;
    border-bottom: 3px solid #555;
}
  #result ul{ 
   list-style: none;
   width: 110%;
   padding-right: 0%;
   position: relative;
   padding-left: 0px;
   border: 1px solid #d7d1d1 !important;
   margin-top: 2px;
   margin-left: -11px;
   z-index: 1; 
   background:#999;
   color: #fff;
   box-shadow: 0px 1px 0px 2px rgb(0 0 0 / 30%);
}
#result ul li{ 
    padding: 4px;
    margin-bottom: 1px;
    border-bottom: 1px solid #d7d1d1 !important;
}
#result ul li:hover{ 
   cursor: pointer; 
}
</style>
{/literal}

{if $API_KEY neq ''}
<script src="https://unpkg.com/@google/markerclustererplus@4.0.1/dist/markerclustererplus.min.js"></script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key={$API_KEY}&callback=initMap">
</script>

{literal}
    <script type='text/javascript'>

    var flightPath;
    var map;
    function initMap() {
      map = new google.maps.Map(document.getElementById('map'), {
        zoom: 3,
        center: {lat: 0, lng: -180},
        mapTypeId: 'terrain'
      });
    }

    setTimeout(function(){
      if(!map){
        initMap();
      }
    },500);

    function drawRoute(data){
      if(!map){
        initMap();
      }

      var flightPlanCoordinates2 = [];
      //map.setCenter({lat:parseInt(data[0].lat), lng:parseInt(data[0].lng)});
      jQuery.each(data, function( index, value ) {
        flightPlanCoordinates2.push({lat:parseFloat(value.lat),lng:parseFloat(value.lng),info:value.label,icon:'http://maps.google.com/mapfiles/ms/icons/blue-dot.png'});

        if(value.check_in_latitude && value.check_in_longitude){
          var content = '<div id="bodyContent"><table class="table table-bordered"><tr><td> Name </td><td><b>'+value.label+' </b></td></tr><tr><td> Point Type </td><td><b>Check In Location</b></td></tr></div>';
          flightPlanCoordinates2.push({lat:parseFloat(value.check_in_latitude),lng:parseFloat(value.check_in_longitude),info:content,icon:'http://maps.google.com/mapfiles/ms/icons/green-dot.png'});
        }

        if(value.check_out_latitude && value.check_out_longitude){
          var content = '<div id="bodyContent"><table class="table table-bordered"><tr><td> Name </td><td><b>'+value.label+' </b></td></tr><tr><td> Point Type </td><td><b>Check Out Location</b></td></tr></div>';
          flightPlanCoordinates2.push({lat:parseFloat(value.check_in_latitude),lng:parseFloat(value.check_in_longitude),info:content,icon:'http://maps.google.com/mapfiles/ms/icons/red-dot.png'});
        }
          //markers[i] = marker;  
      });
      var infoWin = new google.maps.InfoWindow();
      if(flightPlanCoordinates2){
        var markers = flightPlanCoordinates2.map(function(location, i) {
          var marker = new google.maps.Marker({
            position: location,
            map: map,
            icon:{
              url:location.icon
            }
          });
          google.maps.event.addListener(marker, 'mouseover', function(evt) {
            infoWin.setContent(location.info);
            infoWin.open(map, marker);
          })
          map.setCenter(marker.getPosition());
          google.maps.event.addListener(marker, 'mouseout', function(evt) {
            infoWin.close(map, marker);
          })
          map.setCenter(marker.getPosition());
          return marker;
        });
      }

      var mcOptions = {
          imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m',
          infoOnClick: true, 
          infoOnClickZoom: 7
      };
  
      markerCluster = new MarkerClusterer(map, markers, mcOptions);

      google.maps.event.addListener(markerCluster, "clusterclick", multiChoice);
    }


    function multiChoice(cluster) {
             /*var cluster = mc.clusters_;*/
             var zoom = markerCluster.getMap().getZoom();
             var maxZoom = 15;
             // if more than 1 point shares the same lat/long
             // the size of the cluster array will be 1 AND
             // the number of markers in the cluster will be > 1
             // REMEMBER: maxZoom was already reached and we can't zoom in anymore
             if (zoom >= maxZoom == 1 && cluster.markers_.length > 1)
             {
                  var markers = cluster.markers_;
                  var a = 360.0 / markers.length;
                  for (var i=0; i < markers.length; i++)
                  {
                      var pos = markers[i].getPosition();
                      var newLat = pos.lat() + -.00002 * Math.cos((+a*i) / 180 * Math.PI);  // x
                      var newLng = pos.lng() + -.00002 * Math.sin((+a*i) / 180 * Math.PI);  // Y
                      var finalLatLng = new google.maps.LatLng(newLat,newLng);
                      markers[i].setPosition(finalLatLng);
                      markers[i].setMap(markerCluster.getMap());
                  }
                  cluster.clusterIcon_.hide();
                  return ;
             }

             return true;
        }



    </script>
{/literal}
{else}
  <script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>
  <link href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" rel="stylesheet"/>
    {literal}
        <script type='text/javascript'>
              var markers = [];
              var myMap = '';
              var flightPlanCoordinates = [];
              function initOpenMap() {
                  var element = document.getElementById('map');
                  //element.style = 'height:300px;';
                  myMap = L.map(element);

                  // Add OSM tile leayer to the Leaflet map.
                  var mylayer = L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
                      attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
                  }).addTo(myMap);
              }
              jQuery(document).ready(function () { 
                initOpenMap();
              });

              function drawRoute(result2){
                if(result2.length != 0){
                  
                  
                  var target = L.latLng(result2[0].lat,result2[0].lng);

                  // Set map's center to target with zoom 14.
                  myMap.setView(target, 10);

                  jQuery.each(result2, function(index, item) {
                    i =index;
                    marker = new L.marker([item.lat, item.lng])
                      .bindPopup(item.label)
                      .addTo(myMap);
                      marker.on('mouseover', function(event){
                      marker.openPopup();
                    });
                    
                  });
                }
              }
        </script>
      {/literal}
{/if}

<div class="container-fluid">
<input type="hidden" id="record" value="{$RECORD}">
<input type="hidden" id="step" value="{$STEP}">
<input type="hidden" id="api_key" value="{$API_KEY}">
    <div class="widget_header row-fluid">
        <button type="button" class="btn btn-info pull-right" style="background:#287DF2 !important;" onclick='window.location.href="{CTMobileSettings_Module_Model::$CTMOBILE_DETAILVIEW_URL}"'>{vtranslate('Go To CRMTiger Settings',$MODULE)}</button>
        <h3>{vtranslate('Create Route Planning', 'CTMobileSettings')}</h3>
    </div>
    <hr>
    <!-- <h5 style="margin-left:20px;">{vtranslate('Add/Remove users from list to access of route planning','CTMobileSettings')}</h5> -->
    <div class="clearfix"></div>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item {if $STEP eq 1} active {/if}" aria-current="page"><a href="#"> {vtranslate('Add Stops','CTMobileSettings')}</a></li>
        <li class="breadcrumb-item {if $STEP eq 2} active {/if}"><a href="#"> {vtranslate('Review Route & optimize','CTMobileSettings')}</a></li>
        <li class="breadcrumb-item"><a href="#"> {vtranslate('Dispatch Route','CTMobileSettings')}</a></li>
      </ol>
    </nav>
    <div class="tab-content massEditContent">
        <div class="summaryWidgetContainer row" id="route_analytics_settings">
            <div class="col-md-6">
                  <div class="row">
                    <div class="col-md-4">
                      <input type="text" class="inputElement" id="routename" name="routename" value="{$ROUTENAME}" placeholder="Enter Route Name" />
                    </div>
                    <div class="col-md-4">
                      <input type="text" class="dateField form-control" id="routedate" name="routedate" data-date-format="dd-mm-yyyy" value="{$ROUTEDATE}" placeholder="Route Date" />
                    </div>
                    <div class="col-md-4">  
                      <select data-fieldname="routeUser" name="user_id" id="routeUser" data-fieldtype="picklist" class="inputElement select2">
                        {foreach key=FIELD_NAME item=FIELD_MODEL from=$USER_MODEL}
                            <option value="{$FIELD_MODEL['userid']}" data-field-name="{$FIELD_MODEL['username']}"
                                     {if $assigned_user_id eq $FIELD_MODEL['userid']} selected {/if}>{$FIELD_MODEL['username']}
                            </option>
                        {/foreach}
                      </select>
                    </div>
                  </div>
                  <br/>
                  <div id="listRoute">
                      <table id="example1" class='table table-bordered table-striped'>
                          <thead>
                              <tr><th>{vtranslate('Module','CTMobileSettings')}</th><th> {vtranslate('Record label','CTMobileSettings')} </th><th> {vtranslate('Full Address','CTMobileSettings')} </th><th>{vtranslate('LBL_ACTION','CTMobileSettings')}</th></tr>
                          </thead>
                          <tbody>
                          {foreach item=RelData from=$relatedData}
                          <tr data-crmid="{$RelData['crmid']}" data-label="{$RelData['label']}" data-address="{$RelData['address']}" data-latitude="{$RelData['latitude']}" data-longitude="{$RelData['longitude']}" data-check_in_latitude="{$RelData['check_in_latitude']}" data-check_in_longitude="{$RelData['check_in_longitude']}" data-check_out_latitude="{$RelData['check_out_latitude']}" data-check_out_longitude="{$RelData['check_out_longitude']}">
                            <td>{vtranslate($RelData['setype'],$RelData['setype'])}</td>
                            <td>{$RelData['label']}</td>
                            <td>{$RelData['address']}</td>
                            <td><a class='btn btn-danger deleteStops' onclick='deleteStops(this)' title='Delete'><i class='fa fa-trash'></i></a></td>
                          </tr>
                          {/foreach}
                          </tbody>
                      </table>
                      {if $STEP eq 1}  
                        <button id="secondstep" class="btn btn-info pull-right" style="background:#287DF2 !important;margin-right: 15px;">Next</button>
                      {else}
                        <button id="saveRoute" class="btn btn-success pull-right" style="background:#35aa47 !important;margin-right: 15px;">{vtranslate('LBL_SAVE','CTMobileSettings')}</button>
                        <button id="prevStep" class="btn btn-info pull-right" style="background:#287DF2 !important;margin-right: 15px;">{vtranslate('Prev','CTMobileSettings')}</button>
                      {/if} 
                 </div>

            </div>
            <div class="col-md-6">
              {if $STEP eq 1}  
                <button type="button" id="AddStops" class="btn btn-info pull-right" style="background:#287DF2 !important;    margin-bottom: 10px;"><i class="fa fa-plus" ></i> {vtranslate('Add Stops',$MODULE)}</button>

              {/if}
              <div id='map' style="width:100%;min-height: 35em; margin: 0; padding: 0;margin-top: 14px;">
              </div>
           </div> 
             
                    
        </div>
    </div>

</div>


