{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is: vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}

  <link rel="stylesheet" type="text/css" href="layouts/v7/modules/CTMobileSettings/dataTables.bootstrap.min.css" />
  <script type="text/javascript" src="layouts/v7/modules/CTMobileSettings/jquery.dataTables.min.js"></script>
  <script type="text/javascript" src="layouts/v7/modules/CTMobileSettings/dataTables.bootstrap.min.js"></script>

  <script type="text/javascript" src="layouts/v7/modules/CTMobileSettings/resources/moment.min.js"></script>
  <script type="text/javascript" src="layouts/v7/modules/CTMobileSettings/resources/daterangepicker.min.js"></script>
  
  <link rel="stylesheet" type="text/css" href="layouts/v7/modules/CTMobileSettings/daterangepicker.css" />

  <div class="container-fluid main_notification_settings" id="notification_settings_block">
      <div class="widget_header row-fluid">
        <button type="button" class="btn btn-info pull-right" style="background:#287DF2 !important;" onclick='window.location.href="{CTMobileSettings_Module_Model::$CTMOBILE_DETAILVIEW_URL}"'>{vtranslate('Go To CRMTiger Settings',$MODULE)}</button>
        <h3>{vtranslate('CRMTiger Mobile Apps - Route Planning', 'CTMobileSettings')}</h3>

        <div class="clearfix"></div>
      </div>
  </div>
   <br/>
   <div class="col-sm-12 col-xs-12 ">
          <button class="btn btn-info pull-right" style="margin-top:20px" onclick="window.location.href='index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit'">Create Route</button>
            <div id="listview-actions" class="listview-actions-container">
            
            </div>
            <div class="list-content row">
                <div class="col-sm-12 col-xs-12 ">
                 <div id="table-content" class="table-container" style="padding-top:0px !important;">
                    <table id="listview-table"  class="table listview-table">
                       <thead>
                          <tr class="listViewContentHeader">
                            <th>{vtranslate('LBL_ROUTENAME',$MODULE)}</th>
                            <th>{vtranslate('LBL_DATE_OF_ROUTE',$MODULE)}</th>
                            <th>{vtranslate('LBL_ASSIGNED_TO',$MODULE)}</th>
                            <th>{vtranslate('LBL_ROUTE_STATUS',$MODULE)}</th>
                            <th>{vtranslate('LBL_ACTION',$MODULE)}</th>
                          </tr>
                       </thead>
                       <tbody class="overflow-y">
                       </tbody>
                    </table>
                 </div>
                 <div id="scroller_wrapper" class="bottom-fixed-scroll">
                    <div id="scroller" class="scroller-div"></div>
                </div>
                </div>
              </div>
        </div>
    </div>
{/strip}

<script type="text/javascript">
  jQuery(document).ready(function () {
      getRouteListData();
  });

  function getRouteListData(recordid=''){

    //var listdaterange = jQuery('#listdaterange').val();
    //var listUsers = jQuery('#listUsers').val();

    var mainmodule = app.getModuleName();
    var parentmodule = app.getParentModuleName();
    var view = 'RoutePlanning';
    var mode = 'getRouteList';
    var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&view="+view+"&mode="+mode;
    table = jQuery('#listview-table').DataTable({
      'paging'      : true,
      'lengthChange': false,
      'searching'   : false,
      'ordering'    : false,
      'info'        : true,
      'autoWidth'   : false,
      'pageLength' : 20,
      'processing': true,
      'serverSide': true,
      'serverMethod': 'post',
      'destroy': true,
      'ajax': {
          'url':url
      },
      "language": {
          "sProcessing": app.vtranslate('Processing'),
          "sEmptyTable": app.vtranslate('No data available in table'),
          "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
          "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
          "oPaginate": {
              "sFirst": app.vtranslate('First'),   
              "sLast": app.vtranslate('Last'),  
              "sNext":   app.vtranslate('Next'), 
              "sPrevious": app.vtranslate('Previous'),
          },
      },
      "columns": [
        { "data": "route_name" },
        { "data": "date_of_route" },
        { "data": "assigned_to" },
        { "data": "route_status" },
        { "data": "action" }
      ]
      });

}
</script>
