<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobileSettings_APILogsSettings_View extends Settings_Vtiger_Index_View {

    function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('CRMTiger Mobile Apps',$qualifiedModuleName).' > '.vtranslate('API Logs',$qualifiedModuleName);
    }

    function __construct() {
        parent::__construct();
    }

    public function checkPermission(Vtiger_Request $request) {
        $license_data = CTMobileSettings_Module_Model::getLicenseData();
        if(strtolower($license_data['Plan']) === 'free'){
            throw new AppException(vtranslate('LBL_PERMISSION_DENIED', 'Vtiger'));
        }else{
            $currentUserModel = Users_Record_Model::getCurrentUserModel();
            if(!$currentUserModel->isAdminUser()) {
                throw new AppException(vtranslate('LBL_PERMISSION_DENIED', 'Vtiger'));
            }
        }
    }


    public function process(Vtiger_Request $request) {
        $currentUser = Users_Record_Model::getCurrentUserModel();
        $module = $request->getModule();
        $adb = PearDatabase::getInstance();
        $mode = $request->getMode();
       
        $viewer = $this->getViewer($request);
        $query = $adb->pquery("SELECT user_setting_value FROM ctmobile_user_settings WHERE user_setting_type=?", array('api_logs'));
        $ALLOW_API_LOGS = $adb->query_result($query,0,'user_setting_value');
        $viewer->assign('ALLOW_APILOGS',$ALLOW_API_LOGS);
        echo $viewer->view('CTMobileAPILogsSettings.tpl',$module,true);
        
    }

    /**
     * Function to get the list of Script models to be included
     * @param Vtiger_Request $request
     * @return <Array> - List of Vtiger_JsScript_Model instances
     */
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.CTMobileSettings.resources.APILogsSettings",
            '~/libraries/jquery/bootstrapswitch/js/bootstrap-switch.min.js'
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    public function getHeaderCss(Vtiger_Request $request) {
        $headerCssInstances = parent::getHeaderCss($request);
        $cssFileNames = array(
            '~/libraries/jquery/bootstrapswitch/css/bootstrap3/bootstrap-switch.min.css'
        );
        $cssInstances = $this->checkAndConvertCssStyles($cssFileNames);
        $headerCssInstances = array_merge($headerCssInstances, $cssInstances);
        return $headerCssInstances;
    }

}
