<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobileSettings_LicenseEdit_View extends Settings_Vtiger_Index_View {

	function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('CRMTiger Mobile Apps',$qualifiedModuleName).' > '.vtranslate('License Configuration',$qualifiedModuleName);
    }
    
    public function process(Vtiger_Request $request){
        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(false);

		$license_key =  CTMobileSettings_Module_Model::getCTMobileLicense();

		$step = CTMobileSettings_Module_Model::updateStatusExtension();
		$viewer->assign('step', $step);
		
        $viewer->assign('LICENCE_KEY',$license_key);
        $viewer->assign('MODULE','CTMobileSettings');
        $viewer->view('CTMobileLicenseEdit.tpl',$qualifiedName);
    }
		
   function getHeaderScripts(Vtiger_Request $request) {
		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			"modules.$moduleName.resources.OtherSettings",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
		return $headerScriptInstances;
    }
}
    
