 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_RoutePlanning_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_RoutePlanning_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_RoutePlanning_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_RoutePlanning_Js.editInstance;
    }
},{ 
    
    registerAddStopsEvents : function(){

        jQuery('#AddStops').on('click',function(){
            var popupInstance = Vtiger_Popup_Js.getInstance();
            var params = {};
            params['module'] = "CTMobileSettings";
            params['view'] = "RoutePlanning";
            params['mode'] = "AddStops";
            popupInstance.showPopup(params);
        });

        var step = jQuery('#step').val();
        if(step == 2){
            var routename = window.localStorage.getItem('routename');
            if(routename){
                jQuery('#routename').val(routename);
            }
            var routedate = window.localStorage.getItem('routedate');
            if(routedate){
                jQuery('#routedate').val(routedate);
            }

            var routeUser = window.localStorage.getItem('routeUser');
            if(routeUser){
                jQuery('#routeUser').val(routeUser);
                app.changeSelectElementView(jQuery('#routeUser'));
                app.showSelect2ElementView(jQuery('#routeUser'));
            }
            
            var tabledata = window.localStorage.getItem('table');
            if(tabledata){
                jQuery('#example1 tbody').html(tabledata);
            }

            var trlength = jQuery('#example1 tbody').find('tr').length;
            var data = Array();
            var trr = jQuery('#example1 tbody').find('tr');
            for(var i=0;i<trlength;i++){
                var oldtr = trr[i];
                data.push({'lat':oldtr.getAttribute('data-latitude'),'lng':oldtr.getAttribute('data-longitude'),'label':oldtr.getAttribute('data-label'),'check_in_latitude':oldtr.getAttribute('data-check_in_latitude'),'check_in_longitude':oldtr.getAttribute('data-check_in_longitude'),'check_out_latitude':oldtr.getAttribute('data-check_out_latitude'),'check_out_longitude':oldtr.getAttribute('data-check_out_longitude')});
            }
            if(data.length > 0){
                setTimeout(function(){
                    drawRoute(data);
                },500);
            }
        }else if(step ==1){
            var record = jQuery('#record').val();
            if(record == ''){
                var routename = window.localStorage.getItem('routename');
                if(routename){
                    jQuery('#routename').val(routename);
                }
                var routedate = window.localStorage.getItem('routedate');
                if(routedate){
                    jQuery('#routedate').val(routedate);
                }

                var routeUser = window.localStorage.getItem('routeUser');
                if(routeUser){
                    jQuery('#routeUser').val(routeUser);
                    app.changeSelectElementView(jQuery('#routeUser'));
                    app.showSelect2ElementView(jQuery('#routeUser'));
                }
                
                var tabledata = window.localStorage.getItem('table');
                if(tabledata){
                    jQuery('#example1 tbody').html(tabledata);
                }

                window.localStorage.setItem('routename', '');
                window.localStorage.setItem('routedate', '');
                window.localStorage.setItem('table', '');
                window.localStorage.setItem('routeUser','');
            }
        }

        jQuery('#saveRoute').on('click',function(){
            var routename = jQuery('#routename').val();
            var record = jQuery('#record').val();
            var routedate = jQuery('#routedate').val();
            var routeUser = jQuery('#routeUser').val();
            var trlength = jQuery('#example1 tbody').find('tr').length;
            var data = Array();
            var trr = jQuery('#example1 tbody').find('tr');
            for(var i=0;i<trlength;i++){
                var oldtr = trr[i];
                data.push(oldtr.getAttribute('data-crmid'));
            }
            var params = {};
            params['module'] = "CTMobileSettings";
            params['view'] = "RoutePlanning";
            params['mode'] = "SaveRoute";
            params['record'] = record;
            params['ctroutename'] = routename;
            params['ctroute_date'] = routedate;
            params['routeUser'] = routeUser;
            params['ctroute_realtedto'] = data;
            AppConnector.request(params).then(function(data) {
                 window.localStorage.setItem('routename', '');
                 window.localStorage.setItem('routedate', '');
                 window.localStorage.setItem('table', '');
                 app.helper.showSuccessNotification({message: app.vtranslate('Route Saved successfully')});
                 location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RouteAnalytics';
            });
        });

        jQuery('#prevStep').on('click',function(){
            var record = jQuery('#record').val();
            if(record){
                location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&record='+record+'&step=step1';
            }else{
                var routename = jQuery('#routename').val();
                var routedate = jQuery('#routedate').val();
                var routeUser = jQuery('#routeUser').val();
                var trlength = jQuery('#example1 tbody').find('tr').length;

                window.localStorage.setItem('routename', routename);
                window.localStorage.setItem('routedate', routedate);
                window.localStorage.setItem('table', jQuery('#example1 tbody').html());
                window.localStorage.setItem('routeUser',routeUser);
                location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&step=step1';
            }
        });

        jQuery('#secondstep').on('click',function(){
            var routename = jQuery('#routename').val();
            var routedate = jQuery('#routedate').val();
            var routeUser = jQuery('#routeUser').val();
            var trlength = jQuery('#example1 tbody').find('tr').length;

            window.localStorage.setItem('routename', routename);
            window.localStorage.setItem('routedate', routedate);
            window.localStorage.setItem('table', jQuery('#example1 tbody').html());
            window.localStorage.setItem('routeUser',routeUser);

            if(routename.trim() == ''){
                var params = {
                    title : app.vtranslate('Please enter Route Name'),
                    text: app.vtranslate('Please enter Route Name'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
                jQuery('#routename').focus();
            }else if(routedate.trim() == ''){
                var params = {
                    title : app.vtranslate('Please Select Route Date'),
                    text: app.vtranslate('Please Select Route Date'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else if(trlength == 0){
                var params = {
                    title : app.vtranslate('Please add atleast one stop'),
                    text: app.vtranslate('Please add atleast one stop'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else{
                var record = jQuery('#record').val();
                if(record){
                    location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&record='+record+'&step=step2';
                }else{
                    location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&step=step2';
                }
            }
        });
    },

    registerAppTriggerEvent : function() {
        jQuery('.app-menu').removeClass('hide');
        var toggleAppMenu = function(type) {
            var appMenu = jQuery('.app-menu');
            var appNav = jQuery('.app-nav');
            appMenu.appendTo('#page');
            appMenu.css({
                'top' : appNav.offset().top + appNav.height(),
                'left' : 0
            });
            if(typeof type === 'undefined') {
                type = appMenu.is(':hidden') ? 'show' : 'hide';
            }
            if(type == 'show') {
                appMenu.show(200, function() {});
            } else {
                appMenu.hide(200, function() {});
            }
        };

        jQuery('.app-trigger, .app-icon, .app-navigator').on('click',function(e){
            e.stopPropagation();
            toggleAppMenu();
        });

        jQuery('html').on('click', function() {
            toggleAppMenu('hide');
        });

        jQuery(document).keyup(function (e) {
            if (e.keyCode == 27) {
                if(!jQuery('.app-menu').is(':hidden')) {
                    toggleAppMenu('hide');
                }
            }
        });

        jQuery('.app-modules-dropdown-container').hover(function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            jQuery('.dropdown').removeClass('open');
            if(dropdownContainer.length) {
                if(dropdownContainer.hasClass('dropdown-compact')) {
                    dropdownContainer.find('.app-modules-dropdown').css('top', dropdownContainer.position().top - 8);
                } else {
                    dropdownContainer.find('.app-modules-dropdown').css('top', '');
                }
                dropdownContainer.addClass('open').find('.app-item').addClass('active-app-item');
            }
        }, function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            dropdownContainer.find('.app-item').removeClass('active-app-item');
            setTimeout(function() {
                if(dropdownContainer.find('.app-modules-dropdown').length && !dropdownContainer.find('.app-modules-dropdown').is(':hover') && !dropdownContainer.is(':hover')) {
                    dropdownContainer.removeClass('open');
                }
            }, 500);

        });

        jQuery('.app-item').on('click', function() {
            var url = jQuery(this).data('defaultUrl');
            if(url) {
                window.location.href = url;
            }
        });

        jQuery(window).resize(function() {
            jQuery(".app-modules-dropdown").mCustomScrollbar("destroy");
            app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
                setHeight: $(window).height(),
                autoExpandScrollbar: true
            });
            jQuery('.dropdown-modules-compact').each(function() {
                var element = jQuery(this);
                var heightPer = parseFloat(element.data('height'));
                app.helper.showVerticalScroll(element, {
                    setHeight: $(window).height()*heightPer - 3,
                    autoExpandScrollbar: true,
                    scrollbarPosition: 'outside'
                });
            });
        });
        app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
            setHeight: $(window).height(),
            autoExpandScrollbar: true,
            scrollbarPosition: 'outside'
        });
        jQuery('.dropdown-modules-compact').each(function() {
            var element = jQuery(this);
            var heightPer = parseFloat(element.data('height'));
            app.helper.showVerticalScroll(element, {
                setHeight: $(window).height()*heightPer - 3,
                autoExpandScrollbar: true,
                scrollbarPosition: 'outside'
            });
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerAppTriggerEvent();  
        this.registerAddStopsEvents();
    }
});


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_RoutePlanning_Js();
    instance.registerEvents();

});


function deleteStops(event){
  var message = app.vtranslate('Are you sure want to delete this record ?');
  app.helper.showConfirmationBox({'message' : message}).then(function(data) {
    event.parentNode.parentNode.remove();
  });
}


