<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */


class CTMobile_WS_Dashboard extends CTMobile_WS_Controller {
	
	protected $attendance_checkin = false;
	protected $nearby_customer = false;
	protected $time_tracker_access = false;

	function process(CTMobile_API_Request $request) {
		global $adb,$current_user; // Required for vtws_update API
		$current_user = $this->getActiveUser();

		$response = new CTMobile_API_Response();
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$presence = array('0', '2');
		$moduleModel = Vtiger_Module_Model::getInstance('Dashboard');
		if(($userPrivModel->isAdminUser() ||
								$userPrivModel->hasGlobalReadPermission() ||
								$userPrivModel->hasModulePermission($moduleModel->get('id'))) &&in_array($moduleModel->get('presence'), $presence)){

			//for livetracking access to user
			$checkPermLive = $adb->pquery("SELECT user_setting_type,user_setting_value FROM ctmobile_user_settings WHERE user_setting_type = ? AND user_setting_value = ?",array('location_tracking','1'));
			if($adb->num_rows($checkPermLive) > 0){
				$liveuserQuery = $adb->pquery("SELECT 1 FROM ctmobile_livetracking_users WHERE userid = ?",array($current_user->id));
				if($adb->num_rows($liveuserQuery) > 0){
					$livetracking = true;
				}else{
					$livetracking = false;
				}
			}else{
				$livetracking = false;
		    }

		    if($livetracking){
		    	$n_result = $adb->pquery("SELECT * FROM ctmobile_premium_feature WHERE feature_name = ? AND feature_enabled = '1'",array('nearby_customer'));
		    	if($adb->num_rows($n_result)){
		    		$this->nearby_customer = true;
		    	}
		    	$ATModuleModel = Vtiger_Module_Model::getInstance('CTAttendance');
				if(($userPrivModel->isAdminUser() ||
									$userPrivModel->hasGlobalReadPermission() ||
									$userPrivModel->hasModulePermission($ATModuleModel->get('id'))) && in_array($ATModuleModel->get('presence'), $presence) ){
			    	$a_result = $adb->pquery("SELECT * FROM ctmobile_premium_feature WHERE feature_name = ? AND feature_enabled = '1'",array('attendance_checkin'));
			    	if($adb->num_rows($a_result)){
			    		$this->attendance_checkin = true;
			    	}
			    }
		    }
		    //for timetracking permission to use
			$checkPermtime = $adb->pquery("SELECT user_setting_type,user_setting_value FROM ctmobile_user_settings WHERE user_setting_type = ? AND user_setting_value = ?",array('time_tracker','1'));
			if($adb->num_rows($checkPermtime) > 0){
				$moduleModel = Vtiger_Module_Model::getInstance('CTTimeTracker');
				if(($userPrivModel->isAdminUser() ||
									$userPrivModel->hasGlobalReadPermission() ||
									$userPrivModel->hasModulePermission($moduleModel->get('id'))) && in_array($moduleModel->get('presence'), $presence) ){
					$this->time_tracker_access = true;
				}

			}

			if($this->attendance_checkin){
				$attendance_status = $this->attendance_status();
			}else{
				$attendance_status = false;
			}

			$dashboardWidgetsList = $this->getActiveDashboardWidgetsList();
			if(!empty($dashboardWidgetsList)){
				$WidgetsList = $dashboardWidgetsList['WidgetsList'];
				$ReportsList = $dashboardWidgetsList['ReportsList'];
			}else{
				$WidgetsList =  array();
				$ReportsList = array();
			}
			$userid = $current_user->id;
			$sequence_list = array();
			$seq_query = "SELECT * FROM ctmobile_dashboard_sequence WHERE userid = ?";
			$seq_result =  $adb->pquery($seq_query,array($userid));
			if($adb->num_rows($seq_result) > 0){
				for ($i=0; $i < $adb->num_rows($seq_result); $i++) { 
					$id = $adb->query_result($seq_result,$i,'id');
					$type = $adb->query_result($seq_result,$i,'type');
					$sequence_list[] =  array('id'=>$id,'type'=>$type);
				}
			}
			$isRead = $this->getReadStatus();
			if($this->time_tracker_access){
				$timetracking_data = $this->timetracking_data();
			}else{
				$timetracking_data['isTimeTracking'] = false;
				$timetracking_data['time_tracking_record'] = "";
				$timetracking_data['tracking_title'] = "";
				$timetracking_data['related_record'] = "";
				$timetracking_data['related_record_title'] = "";
				$timetracking_data['related_module'] = "";
				$timetracking_data['tracking_status'] = "";
			}
			$result = array('attendance_status'=>$attendance_status,'timetracking_data'=>$timetracking_data,'isRead'=>$isRead,'EventsLabel'=>vtranslate('Events','Events'),'WidgetsList'=>$WidgetsList,'ReportsList'=>$ReportsList,'sequence_list'=>$sequence_list);
			$response->setResult($result);
		}else{
			$message = 'You don\'t have permission of Dashboard. Please contact to Administrator of CRM.';
			$response->setError(403,$message);
		}
		return $response;
	}

	function getActiveDashboardWidgetsList(){
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user,$adb; // Required for vtws_update API
		$current_user = $this->getActiveUser();

		$moduleName = 'Home';
		$dashBoardModel = Vtiger_DashBoard_Model::getInstance($moduleName);

		//check profile permissions for Dashboards
		$moduleModel = Vtiger_Module_Model::getInstance('Dashboard');
		$userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
		$permission = $userPrivilegesModel->hasModulePermission($moduleModel->getId());
		if($permission) {
			// TODO : Need to optimize the widget which are retrieving twice
		   $dashboardTabs = $dashBoardModel->getActiveTabs();
		   $tabid = $dashboardTabs[0]["id"];
		   $dashBoardModel->set("tabid",$tabid);
		   $widgets1 = $dashBoardModel->getDashboards($moduleName);
		   $widgets2 = $dashBoardModel->getSelectableDashboard();

		   //$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		   $widgets['WidgetsList'] = array();

		   

		    
			if($this->nearby_customer){
		   		$widgets['WidgetsList'][] = array('widgetid'=>'1','widgetname'=>'near_by','widgetlabel'=>$this->CTTranslate('nearby'),'is_added'=>true,'sequence'=>0);
			}
		    if($this->time_tracker_access){
		  	 	$widgets['WidgetsList'][] = array('widgetid'=>'2','widgetname'=>'time_tracking','widgetlabel'=>$this->CTTranslate('time_tracker'),'is_added'=>true,'sequence'=>0);
		    }
		    if($this->attendance_checkin){
		   		$widgets['WidgetsList'][] = array('widgetid'=>'3','widgetname'=>'shift','widgetlabel'=>$this->CTTranslate('Attendance'),'is_added'=>true,'sequence'=>0);
		    }
		   $widgets['ReportsList'] = array();
		   $allowedWidgets = array('Open Tickets','Upcoming Activities','Overdue Activities','Funnel Amount','History','Key Metrics','Potentials by Stage','Pipelined Amount');
		   $addedReport = array();

		   $sequence_list = array();
		  
		   $userid = $current_user->id;
		   $seq_query = "SELECT * FROM ctmobile_dashboard_sequence WHERE userid = ?";
		   $seq_result =  $adb->pquery($seq_query,array($userid));
		   if($adb->num_rows($seq_result) > 0){
			  for ($i=0; $i < $adb->num_rows($seq_result); $i++) { 
				  $id = $adb->query_result($seq_result,$i,'id');
				  $type = $adb->query_result($seq_result,$i,'type');
				  $sequence_list[] =  array('id'=>$id,'type'=>$type);
			  }
		   }
		   $max = count($sequence_list);
		   foreach ($widgets1 as $key => $widget) {
		   		if($widget->get('reportid') != ''){
		   			$addedReport[] = $widget->get('reportid');
		   		}
		   		if(in_array($widget->get('linklabel'), $allowedWidgets)){
		   			$skey = searcharray($widget->get('linkid'), 'id', $sequence_list);
		   			if(($skey != "" || $sequence_list[$skey]['id'] == $widget->get('linkid')) && $sequence_list[$skey]['type'] == 'widget'){
		   				$sequence = $skey;
		   			}else{
		   				$sequence = $max++;
		   			}
			   		$widgets['WidgetsList'][] =  array('widgetid'=>$widget->get('linkid'),'widgetname'=>$widget->get('linklabel'),'widgetlabel'=>decode_html(decode_html(vtranslate($widget->get('linklabel'),'Vtiger'))),'is_added'=>true,'sequence'=>$sequence);
			   		$sort[$key] = $widget->get('linkid');
		   		}
		   }
		   foreach ($widgets2 as $key => $widget) {
		   		if(in_array($widget->get('linklabel'), $allowedWidgets)){
		   			$skey = searcharray($widget->get('linkid'), 'id', $sequence_list);
		   			if(($skey != "" || $sequence_list[$skey]['id'] == $widget->get('linkid')) && $sequence_list[$skey]['type'] == 'widget'){
		   				$sequence = $skey;
		   			}else{
		   				$sequence = $max++;
		   			}
			   		$widgets['WidgetsList'][] =  array('widgetid'=>$widget->get('linkid'),'widgetname'=>$widget->get('linklabel'),'widgetlabel'=>decode_html(decode_html(vtranslate($widget->get('linklabel'),'Vtiger'))),'is_added'=>false,'sequence'=>$sequence);
			   		$sort[$key] = $widget->get('linkid');
		   		}
		   }
		   
		   //array_multisort($sort, SORT_ASC, $widgets['WidgetsList']);
		   usort($widgets['WidgetsList'],function($a,$b){
			    return $b['widgetid']-$a['widgetid'];
		   });
		   global $adb;
		   $query = "SELECT vtiger_report.*,vtiger_reportmodules.primarymodule,vtiger_tab.presence FROM vtiger_report INNER JOIN vtiger_reportmodules ON vtiger_report.reportid = vtiger_reportmodules.reportmodulesid INNER JOIN vtiger_tab ON vtiger_reportmodules.primarymodule = vtiger_tab.name WHERE reporttype = ?  AND vtiger_tab.presence IN (0,2)";
		   $results =  $adb->pquery($query,array('chart'));

		    $currentUserGroup = Users_Record_Model::getUserGroups($current_user->id);
		    if(!empty($currentUserGroup)){
				$groupid = $currentUserGroup[0];
			}else{
				$groupid = "0";
			}

		   for($i=0;$i<$adb->num_rows($results);$i++){
		   		$reportid = $adb->query_result($results,$i,'reportid');
		   		$sharingtype = $adb->query_result($results,$i,'sharingtype');
		   		if($sharingtype == 'Private'){
		   			$getSharingUsers = $adb->pquery("SELECT * FROM vtiger_report_shareusers WHERE reportid = ?",array($reportid));
		   			$sharedUsers = array();
		   			for($j=0;$j<$adb->num_rows($getSharingUsers);$j++){
		   				$sharedUsers[] = $adb->query_result($getSharingUsers,$j,'userid');
		   			}

		   			$getSharingRoles = $adb->pquery("SELECT * FROM vtiger_report_sharers WHERE reportid = ?",array($reportid));
		   			$sharedRoles = array();
		   			for($j=0;$j<$adb->num_rows($getSharingRoles);$j++){
		   				$sharedRoles[] = $adb->query_result($getSharingRoles,$j,'rsid');
		   			}

		   			$getSharingGroups = $adb->pquery("SELECT * FROM vtiger_report_sharegroups WHERE reportid = ?",array($reportid));
		   			$sharedGroups = array();
		   			for($j=0;$j<$adb->num_rows($getSharingGroups);$j++){
		   				$sharedGroups[] = $adb->query_result($getSharingGroups,$j,'groupid');
		   			}

		   			if(!in_array($current_user->id, $sharedUsers) && !in_array($current_user->roleid, $sharedRoles) && !in_array($groupid, $sharedGroups)){
		   				continue;
		   			}
		   		}
		   		$reportname = $adb->query_result($results,$i,'reportname');
		   		$reportname = html_entity_decode($reportname, ENT_QUOTES, $default_charset);
		   		$skey = searcharray($reportid, 'id', $sequence_list);
	   			if(($skey != "" || $sequence_list[$skey]['id'] == $reportid) && $sequence_list[$skey]['type'] == 'report'){
	   				$sequence = $skey;
	   			}else{
		   			$sequence = $max++;
		   		}
		   		if(in_array($reportid, $addedReport)){
		   			$is_added = true;
		   		}else{
		   			$is_added = false;
		   		}
		   		$widgets['ReportsList'][] =  array('reportid'=>$reportid,'reportname'=>decode_html(decode_html($reportname)),'is_added'=>$is_added,'sequence'=>$sequence);
		   }
		   return $widgets;
		} else {
			return array();
		}
	}

	function attendance_status(){
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$employee_name = $current_user->id;

		$current_user =  Users::getActiveAdminUser();
		$recentEvent_data = array();
		$generator = new QueryGenerator('CTAttendance', $current_user);
		$generator->setFields(array('employee_name','attendance_status','createdtime','modifiedtime','id'));
		$generator->addCondition('attendance_status', 'check_in', 'e');
		$eventQuery = $generator->getQuery();
		$eventQuery .= " AND vtiger_ctattendance.employee_name = '$employee_name' AND vtiger_ctattendance.eventid = ''";
		
		$query = $adb->pquery($eventQuery);
		
		$num_rows = $adb->num_rows($query);
		if( $num_rows > 0){
			$attendance_status = true;
		} else {
			$attendance_status = false;
		}
		return $attendance_status;
	}

	function timetracking_data(){
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$tracking_user = $current_user->id;
		$getTimeQuery = "SELECT * FROM vtiger_cttimetracker INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_cttimetracker.cttimetrackerid WHERE vtiger_crmentity.deleted = 0 AND vtiger_cttimetracker.tracking_user = '$tracking_user' AND tracking_status = 'Start'";
		$resultTime = $adb->pquery($getTimeQuery,array());
		$data = array();
		$nooftimetracking = $adb->num_rows($resultTime);
		//$isTimeTrackingSameRecord = false;
		$tracking_status = "";
		$time_tracking_record = "";
		$tracking_title = "";
		$related_record = "";
		$related_record_title = "";
		$related_module = "";
		if($adb->num_rows($resultTime) > 0){
			$isTimeTracking = true;
			//$cttimetrackerid = $adb->query_result($resultTime,0,'cttimetrackerid');
			$time_tracking_record = $adb->query_result($resultTime,$nooftimetracking-1,'cttimetrackerid');
			$related_to = $adb->query_result($resultTime,$nooftimetracking-1,'related_to');
			$tracking_title = $adb->query_result($resultTime,$nooftimetracking-1,'tracking_title');
			$related_record = $related_to;
			if($related_record){
				$getLabel = $adb->pquery("SELECT setype,label FROM vtiger_crmentity WHERE crmid = ?",array($related_record));
				if($adb->num_rows($getLabel)){
					$related_module = $adb->query_result($getLabel,0,'setype');
					$related_record = vtws_getWebserviceEntityId($related_module,$related_record);
					$related_record_title = $adb->query_result($getLabel,0,'label');
				}
			}
			$time_tracking_record = vtws_getWebserviceEntityId('CTTimeTracker',$time_tracking_record);
			$time_tracking_status = $adb->query_result($resultTime,$nooftimetracking-1,'tracking_status');
			$tracking_status = $time_tracking_status;
		}else{
			$isTimeTracking = false;
		}

		$data['isTimeTracking'] = $isTimeTracking;
		$data['time_tracking_record'] = $time_tracking_record;
		$data['tracking_title'] = $tracking_title;
		$data['related_record'] = $related_record;
		$data['related_record_title'] = $related_record_title;
		$data['related_module'] = $related_module;
		$data['tracking_status'] = $tracking_status;
		return $data;
	}

	function getReadStatus(){
		global $current_user,$adb;
		$isRead = false;
		$checkstatus = $adb->pquery("SELECT vtiger_ctpushnotification.ctpushnotificationid FROM vtiger_ctpushnotification INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_ctpushnotification.ctpushnotificationid WHERE vtiger_crmentity.deleted = 0 AND (vtiger_ctpushnotification.read_status = 'Unread' OR vtiger_ctpushnotification.read_status IS NULL OR vtiger_ctpushnotification.read_status = '') AND vtiger_crmentity.smownerid = ?",array($current_user->id));
		if($adb->num_rows($checkstatus) == 0){
			$isRead = true;
		}
		return $isRead;
	}

}

function searcharray($value, $key, $array) {
   foreach ($array as $k => $val) {
       if ($val[$key] == $value) {
           return $k;
       }
   }
   return null;
}
