<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/models/Alert.php';
include_once dirname(__FILE__) . '/models/SearchFilter.php';
include_once dirname(__FILE__) . '/models/Paging.php';

class CTMobile_WS_GetMessageTemplate extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $adb, $current_user;
		$current_user = $this->getActiveUser();
		$message_type = trim($request->get('message_type'));
		if($message_type == ''){
			$message = $this->CTTranslate('Required fields not found');
			throw new WebServiceException(404,$message);
		}
		$messageTemplateData = array();
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$presence = array('0', '2');
		$moduleModel = Vtiger_Module_Model::getInstance('CTMessageTemplate');
		if(($userPrivModel->isAdminUser() ||
								$userPrivModel->hasGlobalReadPermission() ||
								$userPrivModel->hasModulePermission($moduleModel->get('id'))) &&in_array($moduleModel->get('presence'), $presence)){
			$getTemplateQuery = $adb->pquery("SELECT * FROM vtiger_ctmessagetemplate INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_ctmessagetemplate.ctmessagetemplateid where vtiger_ctmessagetemplate.message_status = ? AND vtiger_ctmessagetemplate.message_type = ? AND vtiger_crmentity.deleted = 0", array('Active', $message_type));
			$countTemplate = $adb->num_rows($getTemplateQuery);
			
			for($i=0;$i<$countTemplate;$i++){
				$msgTemplateId = trim($adb->query_result($getTemplateQuery, $i, 'ctmessagetemplateid'));
				$templates_name = trim($adb->query_result($getTemplateQuery, $i, 'templates_name'));
				$description = trim($adb->query_result($getTemplateQuery, $i, 'description'));
				$message_status = trim($adb->query_result($getTemplateQuery, $i, 'message_status'));
				//$message_type = trim($adb->query_result($getTemplateQuery, $i, 'message_type'));
				
				$messageTemplateData[] = array('msgTemplateId' => $msgTemplateId, 'templates_name' => $templates_name, 'description' => $description, 'message_status' => $message_status, 'message_type' => $message_type); 
			}


			$getTemplateQuery1 = "SELECT vtiger_emailtemplates.templateid,vtiger_emailtemplates.foldername,vtiger_emailtemplates.templatename,vtiger_emailtemplates.subject, vtiger_emailtemplates.description, vtiger_emailtemplates.body,vtiger_emailtemplates.module FROM vtiger_emailtemplates LEFT JOIN vtiger_tab ON vtiger_tab.name = vtiger_emailtemplates.module AND (vtiger_tab.isentitytype=1 or vtiger_tab.name = 'Users') WHERE (vtiger_tab.presence IN (0,2) OR vtiger_emailtemplates.module IS null OR vtiger_emailtemplates.module = '')";

			$params = array();
			
			if($index != '' || $size != '') {
				$this->totalQuery = $getTemplateQuery1;
				$this->totalParams = $params;
				$limit = ((int)$index*(int)$size) - (int)$size;
				$getTemplateQuery1 .= " LIMIT ".$limit.",".$size;
			}

			$getTemplateResult1 = $adb->pquery($getTemplateQuery1, $params);

			$countTemplate1 = $adb->num_rows($getTemplateResult1);
			
			for($i=0;$i<$countTemplate1;$i++){
				$emailTemplateId = trim($adb->query_result($getTemplateResult1, $i, 'templateid'));
				$template_name = trim($adb->query_result($getTemplateResult1, $i, 'templatename'));
				$subject = trim($adb->query_result($getTemplateResult1, $i, 'subject'));
				$description = trim($adb->query_result($getTemplateResult1, $i, 'description'));
				$module = trim($adb->query_result($getTemplateResult1, $i, 'module'));
				$template_content = decode_html(decode_html(trim($adb->query_result($getTemplateResult1, $i, 'body'))));
				$message_status = 'Active';
				$messageTemplateData[] = array('msgTemplateId' => $emailTemplateId, 'templates_name' => $template_name,'description' => $description, 'message_status' => $message_status, 'message_type' => $message_type); 
			}

		 	$isLast = true;
			if($this->totalQuery != ""){
				$totalResults = $adb->pquery($this->totalQuery,$this->totalParams);
				$totalRecords = $adb->num_rows($totalResults);
				if($totalRecords > $index*$size){
					$isLast = false;	
				}else{
					$isLast = true;
				}
			}
			
			$response = new CTMobile_API_Response();
			$response->setResult(array('records'=>$messageTemplateData,'code'=>'','message'=>''));
			
			if (count($messageTemplateData) == 0) {
				$message = $this->CTTranslate('No Templates found - create it from Message Templates module');
				$response->setResult(array('records'=>array(),'code'=>404,'message'=>$message));
			}
		}else{
			$response = new CTMobile_API_Response();
			$message = 'You don\'t have permission to access '.vtranslate('CTMessageTemplate','CTMessageTemplate');
			$response->setError(403,$message);
		}
		
		return $response;
	}
}

?>
