<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
require_once 'vtlib/Vtiger/Net/Client.php';

class CTMobileSettings_DeactivateCustomerPortal_Action extends Vtiger_Save_Action {
	
    public function process(Vtiger_Request $request) {
        global $adb,$site_URL;
        $license_key = $request->get('license_key');
        $domain = $request->get('domain');
        $getLicenseQuery = $adb->pquery("SELECT * FROM ctcustomerportal_license",array());
        $numOfLicenseCount = $adb->num_rows($getLicenseQuery);
		if($numOfLicenseCount > 0){
			if($license_key == "" && $domain == ""){
				$license_key=$adb->query_result($getLicenseQuery,0,'license_key');
				$domain=$adb->query_result($getLicenseQuery,0,'domain');
			}
			$url = CTMobileSettings_Module_Model::$CTCUSTOMERPORTAL_CHECKLICENSE_URL;

			$serviceURL = $url;
			$postData = array( "license_key"=>$license_key,"domain"=>$domain,"action"=>"deactivate");
			$httpClient = new Vtiger_Net_Client($serviceURL);
		    $result = $httpClient->doPost($postData);
		    $result = trim($result);

			$result_response = json_decode($result,true);
			if($result_response['message'] == 'Deactivated'){
				$deleteLicense = $adb->pquery("DELETE FROM ctcustomerportal_license",array());

				$response = new Vtiger_Response();
				$response->setEmitType(Vtiger_Response::$EMIT_JSON);
				$response->setResult(array("message"=>vtranslate('MSG_DEACTIVATE_LICENSE','CTMobileSettings')));
				$response->emit();
			}else{
				$response = new Vtiger_Response();
				$response->setEmitType(Vtiger_Response::$EMIT_JSON);
				$response->setResult(array("message"=>vtranslate('License Deactivation Failed','CTMobileSettings')));
				$response->emit();
			}
		}
       
    }
}

?>
