<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobileSettings_RoutePlanning_View extends Settings_Vtiger_Index_View {

    public function checkPermission(Vtiger_Request $request) {
        $license_data = CTMobileSettings_Module_Model::getLicenseData();
        if(strtolower($license_data['Plan']) === 'free'){
            throw new AppException(vtranslate('LBL_PERMISSION_DENIED', 'Vtiger'));
        }else{
            return true;
        }
    }

    function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('CRMTiger Mobile Apps',$qualifiedModuleName).' > '.vtranslate('Create Route Planning',$qualifiedModuleName);
    }

    public function process(Vtiger_Request $request) {
        $module = $request->getModule();
        $adb = PearDatabase::getInstance();
        $mode = $request->getMode();
        if($mode == 'AddStops'){
            $viewer = $this->getViewer ($request);
            $AllModules = $this->getModuleList();
            $viewer->assign('ALL_MODULES', $AllModules);
            $viewer->view('AddStops.tpl', $module);
        }else if($mode == 'getRecordbySearch'){
            $searchValue = $request->get('searchvalue');
            $modulename = $request->get('modulename');
            $searchResult  = $this->getSearchResult($searchValue,$modulename);
            $response = new Vtiger_Response();
            //$response->setEmitType(Vtiger_Response::$EMIT_JSON);
            $response->setResult($searchResult);
            $response->emit();
        }else if($mode == 'SaveRoute'){
            $ctroutename = $request->get('ctroutename');
            $ctroute_date = $request->get('ctroute_date');
            $ctrouteidlist = $request->get('ctroute_realtedto');
            $assigned_user_id = $request->get('routeUser');
            $record = $request->get('record');
            if($record){
                $recordModel = Vtiger_Record_Model::getInstanceById($record,'CTRoutePlanning');
                $recordModel->set('mode', 'edit');
                $recordModel->set('id', $record);
            }else{
                $recordModel = Vtiger_Record_Model::getCleanInstance('CTRoutePlanning');
                $recordModel->set('mode', '');
            }

            //$assigned_user = explode('x', $assigned_user_id);
            $recordModel->set('ctroutename',$ctroutename);
            $recordModel->set('ctroute_date',$ctroute_date);
            //$recordModel->set('ctroute_status',$ctroute_status);
            $recordModel->set('assigned_user_id',$assigned_user_id);

            $recordModel->save();
            //$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($moduleName);
            $recordId = $recordModel->getId();
            //$this->recordValues['id'] = $moduleWSId.'x'.$recordId;

            if(!empty($ctrouteidlist) && !empty($recordId)) {
                $adb->pquery( 'DELETE from vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?', array($recordId));

                $count = count($ctrouteidlist);

                $sql = 'INSERT INTO vtiger_ctrouteplanrel VALUES ';
                for($i=0; $i<$count; $i++) {
                    $ctrouteid = $ctrouteidlist[$i];
                    $sql .= " ($recordId,$ctrouteid)";
                    if ($i != $count - 1) {
                        $sql .= ',';
                    }
                }
                $adb->pquery($sql, array());
            } else if ($insertion_mode == "edit" && !empty($recordId)) {
                $adb->pquery('DELETE FROM vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?', array($recordId));
            }

            $response = new Vtiger_Response();
            $response->setResult(true);
            $response->emit();
        }else if($mode == 'Edit'){
            $record = $request->get('record');
            $step = $request->get('step');
            $viewer = $this->getViewer($request);
            if($step == 'step2'){
                $STEP = 2;
            }else{
                $STEP = 1;
            }


            $UsersModel = Users_Record_Model::getCurrentUserModel();
            $users = $UsersModel->getAccessibleUsers();
            $userArray =  array();
            foreach($users as $key => $value){
                $userArray[] = array('userid'=>$key,'username'=>decode_html($value));
            }
           /* $groups = $UsersModel->getAccessibleGroups();
            $groupsArray = array();
            foreach ($groups as $key => $value) {
                $groupsArray[] = array('userid'=>$key,'username'=>$value);
            }*/
            $viewer->assign('USER_MODEL', $userArray);
            //$viewer->assign('GROUPS_MODEL', $groupsArray);
            $ctroutename = '';
            $assigned_user_id = '';
            $dateuitype = new Vtiger_Date_UiType();
            $RouteDate = $dateuitype->getDisplayValue(date('Y-m-d'));
            /*code by sapna*/
            $viewer->assign('CUSTOM_MODULE_LIST', $this->getModuleList());
            /*code by sapna end*/

            $Api = CTMobileSettings_Module_Model::getGoogleApiKey();
            
            $viewer->assign('API_KEY', $Api);
            $viewer->assign('CURRENT_USER', $UsersModel);
            $viewer->assign('STEP', $STEP);
            if($record){
                $query = 'SELECT label, crmid, setype, createdtime FROM vtiger_crmentity WHERE crmid = ? AND vtiger_crmentity.deleted = 0';
                $result = $adb->pquery($query,array($record));
                if($adb->num_rows($result)){
                    $recordModel =  Vtiger_Record_Model::getInstanceById($record,'CTRoutePlanning');
                    $ctroutename = $recordModel->get('ctroutename');
                    $ctroute_date = $recordModel->get('ctroute_date');
                    $assigned_user_id = $recordModel->get('assigned_user_id');
                    $ctroute_status = $recordModel->get('ctroute_status');
                    $dateuitype = new Vtiger_Date_UiType();
                    $RouteDate = $dateuitype->getDisplayValue($ctroute_date);

                    $relatedData = array();
                    $query2 = "SELECT vtiger_crmentity.crmid,vtiger_crmentity.label,vtiger_crmentity.setype FROM vtiger_ctrouteplanrel INNER JOIN vtiger_crmentity ON vtiger_ctrouteplanrel.ctroute_realtedto = vtiger_crmentity.crmid WHERE vtiger_ctrouteplanrel.ctrouteplanningid = ?";
                    $result2 = $adb->pquery($query2,array($record));
                    for ($i=0; $i < $adb->num_rows($result2); $i++) {
                        $crmid = $adb->query_result($result2, $i,'crmid');
                        $label = $adb->query_result($result2, $i,'label');
                        $moduleName = $adb->query_result($result2, $i,'setype');
                        $address = $this->getAddress($moduleName,$crmid);
                        $locationdata = $this->getLatLong($crmid);
                        $latitude = $locationdata['latitude'];
                        $longitude = $locationdata['longitude'];
                        $checkinoutlocation = $this->getcheckinoutlocation($crmid,$record);
                        $check_in_latitude = $checkinoutlocation['check_in_latitude'];
                        $check_in_longitude = $checkinoutlocation['check_in_longitude'];
                        $check_out_latitude = $checkinoutlocation['check_out_latitude'];
                        $check_out_longitude = $checkinoutlocation['check_out_longitude'];
                        $relatedData[] = array('crmid'=>$crmid,'label'=>$label,'address'=>$address,'latitude'=>$latitude,'longitude'=>$longitude,'check_in_latitude'=>$check_in_latitude,'check_in_longitude'=>$check_in_longitude,'check_out_latitude'=>$check_out_latitude,'check_out_longitude'=>$check_out_longitude,'setype'=>$moduleName);
                    }
                }
            }
            $viewer->assign('RECORD', $record);
            $viewer->assign('ROUTENAME', $ctroutename);
            $viewer->assign('ROUTEDATE', $RouteDate);
            $viewer->assign('assigned_user_id', $assigned_user_id);
            $viewer->assign('relatedData', $relatedData);
            echo $viewer->view('CreateRoutePlanning.tpl',$module,true);

        }else if($mode == 'getRouteList'){
            $CurrentUserModel = Users_Record_Model::getCurrentUserModel();
            $draw = $_POST['draw'];
            $start = $_POST['start'];
            $length = $_POST['length'];

            /*$listdaterange = $request->get('listdaterange');
            $listUsers = $request->get('listUsers');
            $recordid = $request->get('recordid');*/
            /*$date = explode(' - ',$listdaterange);
            $startdate = date("Y-m-d", strtotime($date[0]));
            $enddate = date("Y-m-d", strtotime($date[1]));*/
            $sql = "SELECT vtiger_ctrouteplanning.ctrouteplanningid,vtiger_ctrouteplanning.ctroutename,vtiger_ctrouteplanning.ctroute_date,vtiger_ctrouteplanning.ctroute_status,
            vtiger_users.first_name, vtiger_users.last_name FROM vtiger_ctrouteplanning INNER JOIN vtiger_crmentity entity1 ON entity1.crmid =  vtiger_ctrouteplanning.ctrouteplanningid INNER JOIN vtiger_users ON vtiger_users.id = entity1.smownerid
                WHERE entity1.deleted = 0";
            if($listUsers != '' && $listUsers != 'all'){
                $sql.=" AND entity1.smownerid = '$listUsers'";
            }
           /* if($startdate != '' && $enddate != ''){
                $sql.=" AND vtiger_ctrouteplanning.ctroute_date BETWEEN '$startdate' AND '$enddate' ";
            }*/
            
            $totalSQL = $sql;
            if($start != '' && $length != ''){
                $sql.= " LIMIT $start, $length";
            }
            
            $result = $adb->pquery($sql,array());
            $numofrows = $adb->num_rows($result);
            $entries = array();
            if($numofrows){
                for($i=0;$i<$numofrows;$i++){
                    $row = $adb->query_result_rowdata($result,$i);
                    $dateuitype = new Vtiger_Date_UiType();
                    $row['ctroute_date'] = $dateuitype->getDisplayValue($row['ctroute_date']);
                    $ctroute_status = $row['ctroute_status'];
                    if(Users_Privileges_Model::isPermitted('CTRoutePlanning', 'DetailView', $row['ctrouteplanningid'])){
                        $deleteButton = '';
                        if($CurrentUserModel->get('is_admin') == 'on'){
                            $deleteButton = "<a class='btn btn-danger' href='javascript:deleteRoute(".$row['ctrouteplanningid'].")'><i class='fa fa-trash'></i></a>&nbsp;&nbsp;";
                        }
                        
                        
                        $detailLink = '<a href="index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&record='.$row['ctrouteplanningid'].'"><i class="fa fa-edit"></i></a>';
                        $entries[] = array('route_name'=>$row['ctroutename'],'date_of_route'=>$row['ctroute_date'],'assigned_to'=>decode_html(decode_html($row['first_name'])).' '.decode_html(decode_html($row['last_name'])),'route_status'=>$ctroute_status,'action'=>$detailLink);
                    }
                }
            }

            $totalResult = $adb->pquery($totalSQL,array());
            $totalCount = $adb->num_rows($totalResult);

            $result = array('draw'=>(int)$draw,'recordsTotal'=>$totalCount,'recordsFiltered'=>$totalCount,'data'=>$entries);
            echo json_encode($result);
            exit;
        }else{
            $viewer = $this->getViewer($request);
            echo $viewer->view('RoutePlanning.tpl',$module,true);
        }
    } 


    public function getSearchResult($searchKey, $module=false) {
        $db = PearDatabase::getInstance();

        $query = 'SELECT label, crmid, setype, createdtime FROM vtiger_crmentity WHERE label LIKE ? AND vtiger_crmentity.deleted = 0';
        $params = array("%$searchKey%");

        if($module !== false) {
            $query .= ' AND setype = ?';
            $params[] = $module;
        }

        $query.=' LIMIT 0,10';
        //Remove the ordering for now to improve the speed
        //$query .= ' ORDER BY createdtime DESC';

        $result = $db->pquery($query, $params);
        $noOfRows = $db->num_rows($result);

        $moduleModels = $matchingRecords = $leadIdsList = array();
        for($i=0; $i<$noOfRows; ++$i) {
            $row = $db->query_result_rowdata($result, $i);
            if ($row['setype'] === 'Leads') {
                $leadIdsList[] = $row['crmid'];
            }
        }
        $convertedInfo = Leads_Module_Model::getConvertedInfo($leadIdsList);

        for($i=0, $recordsCount = 0; $i<$noOfRows && $recordsCount<100; ++$i) {
            $row = $db->query_result_rowdata($result, $i);
            if ($row['setype'] === 'Leads' && $convertedInfo[$row['crmid']]) {
                continue;
            }
            if(Users_Privileges_Model::isPermitted($row['setype'], 'DetailView', $row['crmid'])) {
                $row['id'] = $row['crmid'];
                $moduleName = $row['setype'];
                $row['modulelabel'] = vtranslate($row['setype'],$row['setype']);
                //$row['address'] = "";
                $row['address'] = $this->getAddress($moduleName,$row['crmid']);
                $locationdata = $this->getLatLong($row['crmid']);
                $row['latitude'] = $locationdata['latitude'];
                $row['longitude'] = $locationdata['longitude'];
                if($row['latitude'] && $row['longitude']){
                    $matchingRecords[] = $row;
                    $recordsCount++;
                }
            }
        }
        return $matchingRecords;
    }

    function getAddress($module,$crmid){
       global $adb;
       $recordModel = Vtiger_Record_Model::getInstanceById($crmid,$module);
       $resultAddress = $adb->pquery("SELECT * FROM ctmobile_address_fields WHERE module = ?",array($module));
       $count = $adb->num_rows($resultAddress);
       $address = '';
       for($i=0;$i<$count;$i++){
           $fields = $adb->query_result($resultAddress,$i,'fieldname');
           $test = explode(":",$fields);
           $field = $test[1];
           $newField = $recordModel->get($field);
           if($newField != '') {
                if($i+1 == $count){
                       $address .= $newField;
                 }else{
                       $address .= $newField.', ';
                 }
           }
       }
       return $address;
    }

    function getLatLong($crmid){
        global $adb;
        $data = array();
        $data['latitude'] = '';
        $data['longitude'] = '';
        $result = $adb->pquery("SELECT latitude,longitude FROM ct_address_lat_long WHERE recordid = ?",array($crmid));
        if($adb->num_rows($result)){
            $data['latitude'] = $adb->query_result($result,0,'latitude');
            $data['longitude'] = $adb->query_result($result,0,'longitude');
        }
        return $data;
    }

    function getcheckinoutlocation($related_to,$ctroute_planning){
        global $adb;
        $data = array();
        $data['check_in_latitude'] = '';
        $data['check_in_longitude'] = '';
        $data['check_out_latitude'] = '';
        $data['check_out_longitude'] = '';
        $result = $adb->pquery("SELECT check_in_location,check_out_location FROM vtiger_ctrouteattendance WHERE related_to = ? AND ctroute_planning = ?",array($related_to,$ctroute_planning));
        if($adb->num_rows($result)){
            $check_in_location = $adb->query_result($result,0,'check_in_location');
            $check_out_location = $adb->query_result($result,0,'check_out_location');
            if($check_in_location){
                $check_in_location = explode(',', $check_in_location);
                $data['check_in_latitude'] = $check_in_location[0];
                $data['check_in_longitude'] = $check_in_location[1];
            }
            if($check_out_location){
                $check_out_location = explode(',', $check_out_location);
                $data['check_out_latitude'] = $check_out_location[0];
                $data['check_out_longitude'] = $check_out_location[1];
            }
            
        }
        return $data;
    }

    /**
     * Function to get the list of Script models to be included
     * @param Vtiger_Request $request
     * @return <Array> - List of Vtiger_JsScript_Model instances
     */
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.CTMobileSettings.resources.RoutePlanning",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    //display module dropdown in list tab  
    function getModuleList(){
        //$arrModule = array("all" => vtranslate("All Modules"));
        $arrModule = array();
        $array = array('Leads','Contacts','Accounts');
        foreach($array as $module){
            $arrModule[$module] = vtranslate($module,$module);
        }
        return $arrModule;
    }
}
